//#-hidden-code
//
//  Contents.swift
//  spheroArcade
//
//  Created by Jordan Hesse on 2017-04-26.
//  Copyright © 2018 Sphero Inc. All rights reserved.
//
//#-end-hidden-code
/*:#localized(key: "FirstProseBlock")
 To connect, hold Sphero SPRK+ near your iPad. Make sure Bluetooth is on and Sphero is fully charged. Tap "Connect Robot" and look for your Sphero BOLT, Sphero SPRK+, Sphero Mini, BB-8 or BB-9E in the list. Tap on your robot to connect.
 
 Open the Glossary to learn more about the available functions. Tap ![More](threeDots.png "More") in the top right, and then select *Glossary*.

 If you’d like to start over, tap ![More](threeDots.png "More") in the top right, and then select *Reset Page*.
 */
//#-hidden-code
import Foundation
import PlaygroundSupport

//#-end-hidden-code
//#-code-completion(everything, hide)
//#-code-completion(currentmodule, show)
//#-code-completion(identifier, hide, onReady())
//#-code-completion(identifier, show, ., roll(heading:speed:), stopRoll(), wait(for:), setMainLed(color:), setBackLed(brightness:), setStabilization(state:), setCollisionDetection(configuration:), startAiming(), stopAiming(), enableSensors(sensorMask:), disableSensors(), configureLocator(newX:newY:newYaw:), addSensorListener(_:), addCollisionListener(_:), setRawMotor(leftMotorPower:leftMotorMode:rightMotorPower:rightMotorMode:), addFreefallListener(_:), RawMotor, RawMotorMode, forward, reverse, off, brake, ignore, addLandListener(_:), Sound, play(), applause, ding, dizzy, no, sad, complete, success, shake, spin, tap, jump, slowDown, fall, hit, speedUp, powerDown, pop, bounce, plummet, evilLaugh, powerUp, bell, buttonPulse, celebrate, cheering, tick, lightning, bleep, sparkle, bloop, grow, allSounds)
//#-editable-code
func onReady() {
    Sound.powerUp.play()
    // 表示のためにセンサーを有効にする。
    enableSensors(sensorMask: [.locator, .accelerometer, .gyro])

    // 正方形に動く
    var heading = 0
    for i in 1...10 {
        Sound.complete.play()
        
        // 移動
        setMainLed(color: .green)
        roll(heading: heading, speed: 90)
        wait(for: 2.0)

        // 停止
        setMainLed(color: .red)
        stopRoll()
        wait(for: 1.0)
        
        // Y軸周りの回転
        heading = (heading + 90) % 360
    }
    Sound.powerDown.play()
    setMainLed(color: .black)
}

//#-end-editable-code
//#-hidden-code
PlaygroundPage.current.needsIndefiniteExecution = true
setupContent(assessment: TemplateAssessmentController(), userCode: onReady)
//#-end-hidden-code
